/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public final class VoxelBresenhamIterator
implements Iterator<class_2338>,
Iterable<class_2338> {
    private final int x_inc;
    private final int y_inc;
    private final int z_inc;
    private final int doubleAbsDx;
    private final int doubleAbsDy;
    private final int doubleAbsDz;
    private final int length;
    private final class_2338.class_2339 voxel;
    private final class_2350.class_2351 direction;
    private int i = 0;
    private int err_1;
    private int err_2;

    public VoxelBresenhamIterator(class_2338 voxel, class_2338 towards) {
        this(voxel, towards.method_10263(), towards.method_10264(), towards.method_10260());
    }

    public VoxelBresenhamIterator(class_2338 voxel, int x2, int y2, int z2) {
        this.voxel = voxel.method_25503();
        int x1 = this.voxel.method_10263();
        int y1 = this.voxel.method_10264();
        int z1 = this.voxel.method_10260();
        int xVec = x2 - x1;
        int yVec = y2 - y1;
        int zVec = z2 - z1;
        int absDx = Math.abs(xVec);
        int absDy = Math.abs(yVec);
        int absDz = Math.abs(zVec);
        this.x_inc = xVec < 0 ? -1 : 1;
        this.y_inc = yVec < 0 ? -1 : 1;
        this.z_inc = zVec < 0 ? -1 : 1;
        this.doubleAbsDx = absDx << 1;
        this.doubleAbsDy = absDy << 1;
        this.doubleAbsDz = absDz << 1;
        if (absDx >= absDy && absDx >= absDz) {
            this.err_1 = this.doubleAbsDy - absDx;
            this.err_2 = this.doubleAbsDz - absDx;
            this.direction = class_2350.class_2351.field_11048;
            this.length = absDx + 1;
        } else if (absDy >= absDx && absDy >= absDz) {
            this.err_1 = this.doubleAbsDx - absDy;
            this.err_2 = this.doubleAbsDz - absDy;
            this.direction = class_2350.class_2351.field_11052;
            this.length = absDy + 1;
        } else {
            this.err_1 = this.doubleAbsDy - absDz;
            this.err_2 = this.doubleAbsDx - absDz;
            this.direction = class_2350.class_2351.field_11051;
            this.length = absDz + 1;
        }
    }

    @Override
    public boolean hasNext() {
        return this.i < this.length;
    }

    @Override
    public class_2338 next() {
        class_2338 out = this.voxel.method_10062();
        if (this.hasNext()) {
            this.primeNext();
            ++this.i;
        }
        return out;
    }

    private void primeNext() {
        switch (this.direction) {
            case field_11048: {
                if (this.err_1 > 0) {
                    this.voxel.method_10100(0, this.y_inc, 0);
                    this.err_1 -= this.doubleAbsDx;
                }
                if (this.err_2 > 0) {
                    this.voxel.method_10100(0, 0, this.z_inc);
                    this.err_2 -= this.doubleAbsDx;
                }
                this.err_1 += this.doubleAbsDy;
                this.err_2 += this.doubleAbsDz;
                this.voxel.method_10100(this.x_inc, 0, 0);
                break;
            }
            case field_11052: {
                if (this.err_1 > 0) {
                    this.voxel.method_10100(this.x_inc, 0, 0);
                    this.err_1 -= this.doubleAbsDy;
                }
                if (this.err_2 > 0) {
                    this.voxel.method_10100(0, 0, this.z_inc);
                    this.err_2 -= this.doubleAbsDy;
                }
                this.err_1 += this.doubleAbsDx;
                this.err_2 += this.doubleAbsDz;
                this.voxel.method_10100(0, this.y_inc, 0);
                break;
            }
            case field_11051: {
                if (this.err_1 > 0) {
                    this.voxel.method_10100(0, this.y_inc, 0);
                    this.err_1 -= this.doubleAbsDz;
                }
                if (this.err_2 > 0) {
                    this.voxel.method_10100(this.x_inc, 0, 0);
                    this.err_2 -= this.doubleAbsDz;
                }
                this.err_1 += this.doubleAbsDy;
                this.err_2 += this.doubleAbsDx;
                this.voxel.method_10100(0, 0, this.z_inc);
            }
        }
    }

    @Override
    public Iterator<class_2338> iterator() {
        return this;
    }
}

